import numpy as np
from sklearn.metrics import accuracy_score, f1_score

def multiclass_acc(preds, truths):
    """
    Compute the multiclass accuracy w.r.t. groundtruth

    :param preds: Float array representing the predictions, dimension (N,)
    :param truths: Float/int array representing the groundtruth classes, dimension (N,)
    :return: Classification accuracy
    """
    return np.sum(np.round(preds) == np.round(truths)) / float(len(truths))


def test_score_model(preds, labels):
    non_zeros = np.array(
        [i for i, e in enumerate(labels) if e != 0])

    preds_a7 = np.clip(preds, a_min=-3., a_max=3.)
    labels_a7 = np.clip(labels, a_min=-3., a_max=3.)
    acc7 = multiclass_acc(preds_a7, labels_a7)

    mae = np.mean(np.absolute(preds - labels))
    corr = np.corrcoef(preds, labels)[0][1]
    
    preds_zero = preds >= 0
    labels_zero = labels >= 0

    f1_score_zero = f1_score(labels_zero, preds_zero, average="weighted")
    acc2_zero = accuracy_score(labels_zero, preds_zero)
    
    preds_no_zero = preds[non_zeros]
    labels_no_zero = labels[non_zeros]

    preds_no_zero = preds_no_zero > 0
    labels_no_zero = labels_no_zero > 0

    f1_score_no_zero = f1_score(labels_no_zero, preds_no_zero, average="weighted")
    acc2_no_zero = accuracy_score(labels_no_zero, preds_no_zero)

    return acc7, acc2_zero, f1_score_zero, acc2_no_zero, f1_score_no_zero, mae, corr


